package gov.va.med.mhv.rxrefill.service;

import java.util.List;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

import org.springframework.stereotype.Service;

import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.common.api.util.ResponseUtil;
import gov.va.med.mhv.rxrefill.dto.PharmacyPatientDTO;
import gov.va.med.mhv.rxrefill.dto.PrescriptionDTO;
import gov.va.med.mhv.rxrefill.dto.RequestDTO;


@Path("/")
@Service("rxRefillWebService")
public interface PharmacyRefillWebService {

	/**
	 * Execute the GetPharmacyPatient operation
	 *
	 * @param userName
	 * @return
	 */
	@GET
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/pharmpatient/{userProfileId}")
	public PharmacyPatientDTO getPharmacyPatient(@PathParam("userProfileId") Long userProfileId) throws MHVException;

	/**
	 * Execute the GetActivePrescriptions operation
	 *
	 * @param pharmacyPatientJson
	 * @return
	 */
	@GET
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/activerxs/{userProfileId}")
	public ResponseUtil<List<PrescriptionDTO>> getActivePrescriptions(@PathParam("userProfileId") Long userProfileId) throws MHVException;

	/**
	 * Execute the refillPrescriptions operation
	 *
	 * @param pharmacyPatientJson
	 * @return
	*/
	@POST
	@Produces(MediaType.APPLICATION_JSON)
	@Consumes(MediaType.APPLICATION_JSON)
	@Path("/refillrxs/{userProfileId}")
	public List<RequestDTO> refillPrescriptions(@PathParam("userProfileId") Long userProfileId, List<PrescriptionDTO> refillList) throws MHVException;

	/**
	 * Execute the GetLastSuccessfulExtractRequestForUser operation
	 *
	 * @param pharmacyPatientJson
	 * @return
	 */
	@GET
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/lastsuccessfulextractrequest/{userProfileId}")
	public RequestDTO getLastSuccessfulExtractRequest(@PathParam("userProfileId") Long userProfileId) throws MHVException;
	
	/**
	 * Execute the getRequestByFunctionAndInstitution operation
	 *
	 * @param userId, institutionId
	 * @return
	 */
	@GET
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/requestByFunctionAndInstitution/{userProfileId}/{institutionId}")
	public List<RequestDTO> getRequestByFunctionAndInstitution(@PathParam("userProfileId") Long userProfileId,@PathParam("institutionId") Long institutionId) throws MHVException;

	@GET
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/historyrxs/{userProfileId}")
	public ResponseUtil<List<PrescriptionDTO>> getPrescriptionsHistory(@PathParam("userProfileId") Long userProfileId) throws MHVException;
	
	@GET
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/allrxs/{userProfileId}")
	public List<PrescriptionDTO> getAllPrescriptions(@PathParam("userProfileId") Long userProfileId) throws MHVException;
	

	public void refreshHistoricalPrescriptions(Long userProfileId) throws MHVException;
	
	public void  sendRxTrackingEmailNotifications(String fromEmail,String fromEmailName,Long userprofileId,String firstName,String emailAddress,String hostName) throws MHVException;
	
	public void updateTreatmentFacilitesForExistingPatient(Long userprofileId) throws MHVException;
	
	public boolean sendRxTrackingEmailJobStatusNotification(String fromEmail,String fromEmailName,String subject,String bodyMessage,String emailAddress,String emailContentType) throws MHVException;
}
